/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.deployer.lib.logistics.packager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.createmod.catnip.platform.CatnipServices;
import net.liukrast.deployer.lib.logistics.packager.StockInventoryType;
import net.liukrast.deployer.lib.logistics.stockTicker.LogisticalStockGenericResponsePacket;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.mutable.MutableInt;

public abstract class AbstractInventorySummary<K, V> {
    private final Map<K, List<V>> items = new IdentityHashMap<K, List<V>>();
    private List<V> stacksByCount;
    private int totalCount;
    public int contributingLinks;
    private final StockInventoryType<K, V, ?> type;

    public AbstractInventorySummary(StockInventoryType<K, V, ?> type) {
        this.type = type;
    }

    public int getCount(V stack) {
        return this.type.valueHandler().getCount(stack);
    }

    public K keyFrom(V stack) {
        return this.type.valueHandler().fromValue(stack);
    }

    public boolean isSameKeySameComponents(V stack1, V stack2) {
        return this.type.valueHandler().equalsIgnoreCount(stack1, stack2);
    }

    public void setCount(V stack, int count) {
        this.type.valueHandler().setCount(stack, count);
    }

    public V copy(V stack) {
        return this.type.valueHandler().copy(stack);
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public void add(AbstractInventorySummary<K, V> summary) {
        summary.items.forEach((t, k) -> k.forEach(this::add));
    }

    public void add(V stack) {
        this.add(stack, this.getCount(stack));
    }

    public Map<K, List<V>> getItemMap() {
        return this.items;
    }

    public void addAllStacks(List<V> list) {
        for (V stack : list) {
            this.add(stack, this.getCount(stack));
        }
    }

    public AbstractInventorySummary<K, V> copy() {
        AbstractInventorySummary summary = this.type.networkHandler().createSummary();
        this.items.forEach((i, list) -> list.forEach(summary::add));
        return summary;
    }

    public void add(V stack, int count) {
        if (count == 0 || this.type.valueHandler().isEmpty(stack)) {
            return;
        }
        if (this.totalCount < 1000000000) {
            this.totalCount = count > Integer.MAX_VALUE - this.totalCount ? Integer.MAX_VALUE : (this.totalCount += count);
        }
        List stacks = this.items.computeIfAbsent(this.keyFrom(stack), $ -> Lists.newArrayList());
        for (Object existing : stacks) {
            if (!this.isSameKeySameComponents(existing, stack)) continue;
            int existingCount = this.getCount(existing);
            int resultCount = existingCount > Integer.MAX_VALUE - count ? Integer.MAX_VALUE : existingCount + count;
            if (this.getCount(existing) < 1000000000) {
                this.setCount(existing, resultCount);
            }
            return;
        }
        stacks.add(this.copy(stack));
    }

    public boolean erase(V stack) {
        List<V> stacks = this.items.get(this.keyFrom(stack));
        if (stacks == null) {
            return false;
        }
        Iterator<V> iterator = stacks.iterator();
        while (iterator.hasNext()) {
            V existing = iterator.next();
            if (!this.isSameKeySameComponents(existing, stack)) continue;
            this.totalCount -= this.getCount(existing);
            iterator.remove();
            return true;
        }
        return false;
    }

    public int getCountOf(V stack) {
        List<V> list = this.items.get(this.keyFrom(stack));
        if (list == null) {
            return 0;
        }
        for (V entry : list) {
            if (!this.isSameKeySameComponents(entry, stack)) continue;
            return this.getCount(entry);
        }
        return 0;
    }

    public int getTotalOfMatching(Predicate<V> filter) {
        MutableInt sum = new MutableInt();
        this.items.forEach(($, list) -> {
            for (Object stack : list) {
                if (!filter.test(stack)) continue;
                sum.add(this.getCount(stack));
            }
        });
        return sum.getValue();
    }

    public List<V> getStacks() {
        if (this.stacksByCount == null) {
            ArrayList stacks = new ArrayList();
            this.items.forEach((i, list) -> stacks.addAll(list));
            return stacks;
        }
        return this.stacksByCount;
    }

    public List<V> getStacksByCount() {
        if (this.stacksByCount == null) {
            this.stacksByCount = new ArrayList<V>();
            this.items.forEach((i, list) -> this.stacksByCount.addAll((Collection<V>)list));
            this.stacksByCount.sort(Comparator.comparingInt(this::getCount));
        }
        return this.stacksByCount;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void divideAndSendTo(ServerPlayer player, BlockPos pos) {
        List<V> stacks = this.getStacksByCount();
        int remaining = stacks.size();
        ArrayList<V> currentList = null;
        if (stacks.isEmpty()) {
            CatnipServices.NETWORK.sendToClient(player, new LogisticalStockGenericResponsePacket<V>(true, pos, this.type, Collections.emptyList()));
        }
        for (V entry : stacks) {
            if (currentList == null) {
                currentList = new ArrayList<V>(Math.min(100, remaining));
            }
            currentList.add(entry);
            if (--remaining == 0) break;
            if (currentList.size() < 100) continue;
            CatnipServices.NETWORK.sendToClient(player, new LogisticalStockGenericResponsePacket<V>(false, pos, this.type, currentList));
            currentList = null;
        }
        if (currentList != null) {
            CatnipServices.NETWORK.sendToClient(player, new LogisticalStockGenericResponsePacket<V>(true, pos, this.type, currentList));
        }
    }
}

