/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.deployer.lib.logistics.board;

import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockItem;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBlockItem;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.UUID;
import java.util.function.Supplier;
import net.liukrast.deployer.lib.logistics.board.PanelBlockItem;
import net.liukrast.deployer.lib.logistics.board.PanelType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class LogisticallyLinkedPanelBlockItem
extends PanelBlockItem {
    public LogisticallyLinkedPanelBlockItem(Supplier<PanelType<?>> type, Item.Properties properties) {
        super(type, properties);
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        return LogisticallyLinkedBlockItem.isTuned((ItemStack)stack);
    }

    @Override
    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext pContext) {
        ItemStack stack = pContext.getItemInHand();
        BlockPos pos = pContext.getClickedPos();
        Level level = pContext.getLevel();
        Player player = pContext.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        if (player.isShiftKeyDown()) {
            return super.useOn(pContext);
        }
        LogisticallyLinkedBehaviour link = (LogisticallyLinkedBehaviour)BlockEntityBehaviour.get((BlockGetter)level, (BlockPos)pos, (BehaviourType)LogisticallyLinkedBehaviour.TYPE);
        boolean tuned = LogisticallyLinkedBlockItem.isTuned((ItemStack)stack);
        if (link != null) {
            if (level.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            if (!link.mayInteractMessage(player)) {
                return InteractionResult.SUCCESS;
            }
            LogisticallyLinkedBlockItem.assignFrequency((ItemStack)stack, (Player)player, (UUID)link.freqId);
            return InteractionResult.SUCCESS;
        }
        InteractionResult useOn = super.useOn(pContext);
        if (level.isClientSide || useOn == InteractionResult.FAIL) {
            return useOn;
        }
        player.displayClientMessage((Component)(tuned ? CreateLang.translateDirect((String)"logistically_linked.connected", (Object[])new Object[0]) : CreateLang.translateDirect((String)"logistically_linked.new_network_started", (Object[])new Object[0])), true);
        return useOn;
    }

    protected boolean updateCustomBlockEntityTag(@NotNull BlockPos pos, @NotNull Level level, Player player, @NotNull ItemStack stack, @NotNull BlockState state) {
        return super.updateCustomBlockEntityTag(pos, level, player, FactoryPanelBlockItem.fixCtrlCopiedStack((ItemStack)stack), state);
    }

    @Override
    public Component isReadyForPlacement(ItemStack stack, Level level, BlockPos pos, Player player) {
        return LogisticallyLinkedBlockItem.isTuned((ItemStack)stack) ? null : CreateLang.translate((String)"factory_panel.tune_before_placing", (Object[])new Object[0]).component();
    }
}

