/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.deployer.lib.logistics.board;

import com.mojang.serialization.Codec;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelConnection;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelSupportBehaviour;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.createmod.catnip.codecs.CatnipCodecUtils;
import net.createmod.catnip.codecs.CatnipCodecs;
import net.createmod.catnip.gui.ScreenOpener;
import net.liukrast.deployer.lib.logistics.board.BasicPanelScreen;
import net.liukrast.deployer.lib.logistics.board.PanelType;
import net.liukrast.deployer.lib.logistics.board.connection.ConnectionExtra;
import net.liukrast.deployer.lib.logistics.board.connection.PanelConnection;
import net.liukrast.deployer.lib.mixin.FactoryPanelBehaviourAccessor;
import net.liukrast.deployer.lib.mixin.FactoryPanelBehaviourIMixin;
import net.liukrast.deployer.lib.mixin.FilteringBehaviourMixin;
import net.liukrast.deployer.lib.mixinExtensions.FPBExtension;
import net.liukrast.deployer.lib.registry.DeployerPanelConnections;
import net.liukrast.deployer.lib.registry.DeployerRegistries;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPanelBehaviour
extends FactoryPanelBehaviour {
    private final PanelType<?> type;
    private final Reference2ObjectArrayMap<PanelConnection<?>, Supplier<?>> connections = new Reference2ObjectArrayMap();
    protected static final int WAITING = 16766273;
    protected static final int DISABLED = 0x888898;

    public AbstractPanelBehaviour(ValueBoxTransform valueBoxTransform, PanelType<?> type, FactoryPanelBlockEntity be, FactoryPanelBlock.PanelSlot slot) {
        this(type, be, slot);
        ((FilteringBehaviourMixin)((Object)this)).setValueBoxTransform(valueBoxTransform);
    }

    public AbstractPanelBehaviour(PanelType<?> type, FactoryPanelBlockEntity be, FactoryPanelBlock.PanelSlot slot) {
        super(be, slot);
        PanelConnectionBuilder builder = new PanelConnectionBuilder();
        this.addConnections(builder);
        this.connections.putAll(builder.map);
        this.type = type;
    }

    public abstract void addConnections(PanelConnectionBuilder var1);

    public Set<PanelConnection<?>> getConnections() {
        return this.connections.keySet();
    }

    public <T> boolean hasConnection(DeferredHolder<PanelConnection<?>, PanelConnection<T>> connection) {
        return this.hasConnection((PanelConnection)connection.value());
    }

    public boolean hasConnection(PanelConnection<?> connection) {
        return this.connections.containsKey(connection);
    }

    public MutableComponent getDisplayLinkComponent(boolean shortenNumbers) {
        return Component.empty();
    }

    public boolean skipOriginalTick() {
        return true;
    }

    public boolean shouldRenderBulb(boolean original) {
        return false;
    }

    public boolean withFilteringBehaviour() {
        return false;
    }

    public abstract Item getItem();

    public abstract PartialModel getModel(FactoryPanelBlock.PanelState var1, FactoryPanelBlock.PanelType var2);

    public void easyWrite(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
    }

    public void easyRead(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void displayScreen(Player player) {
        if (player instanceof LocalPlayer) {
            ScreenOpener.open(new BasicPanelScreen<AbstractPanelBehaviour>(this));
        }
    }

    public boolean ignoreIssue(@Nullable String issue) {
        return "factory_panel.no_item".equals(issue);
    }

    public int calculatePath(FactoryPanelBehaviour other, int original) {
        return 0x888898;
    }

    public int calculateExtraPath(BlockPos pos) {
        return 0x888898;
    }

    public <T> Optional<T> getConnectionValue(DeferredHolder<PanelConnection<?>, PanelConnection<T>> connection) {
        return this.getConnectionValue((PanelConnection)connection.get());
    }

    public <T> Optional<T> getConnectionValue(PanelConnection<T> connection) {
        if (!this.connections.containsKey(connection)) {
            return Optional.empty();
        }
        return Optional.ofNullable(((Supplier)this.connections.get(connection)).get());
    }

    public void consumeForLinks(Consumer<FactoryPanelSupportBehaviour> consumer) {
        for (FactoryPanelConnection connection : this.targetedByLinks.values()) {
            if (!this.getWorld().isLoaded(connection.from.pos())) {
                return;
            }
            FactoryPanelSupportBehaviour linkAt = AbstractPanelBehaviour.linkAt((BlockAndTintGetter)this.getWorld(), (FactoryPanelConnection)connection);
            if (linkAt == null) {
                return;
            }
            if (!linkAt.isOutput()) continue;
            consumer.accept(linkAt);
        }
    }

    public <T> void consumeForPanels(PanelConnection<T> panelConnection, Consumer<T> consumer, PanelConnection<?> ... toConsider) {
        block0: for (FactoryPanelConnection connection : this.targetedBy.values()) {
            Optional<T> opt;
            if (!this.getWorld().isLoaded(connection.from.pos())) {
                return;
            }
            FactoryPanelBehaviour at = AbstractPanelBehaviour.at((BlockAndTintGetter)this.getWorld(), (FactoryPanelConnection)connection);
            if (at == null) {
                return;
            }
            for (PanelConnection<?> c : DeployerPanelConnections.getConnections(at)) {
                for (PanelConnection<?> consider : toConsider) {
                    if (c == consider) continue block0;
                }
                if (c != panelConnection) continue;
                break;
            }
            if ((opt = DeployerPanelConnections.getConnectionValue(at, panelConnection)).isEmpty()) continue;
            consumer.accept(opt.get());
        }
    }

    public <T> void consumeForExtra(PanelConnection<T> panelConnection, BiConsumer<BlockPos, T> consumer) {
        HashSet<BlockPos> toRemove = new HashSet<BlockPos>();
        for (FactoryPanelConnection connection : ((FPBExtension)((Object)this)).deployer$getExtra().values()) {
            BlockPos pos2 = connection.from.pos();
            if (!this.getWorld().isLoaded(pos2)) {
                return;
            }
            Level level = this.getWorld();
            BlockState state = level.getBlockState(pos2);
            BlockEntity be = level.getBlockEntity(pos2);
            ConnectionExtra<T> listener = panelConnection.getListener(state.getBlock());
            if (listener == null) {
                toRemove.add(connection.from.pos());
                continue;
            }
            Optional<Object> opt = listener.invalidate(level, state, pos2, be);
            opt.ifPresent(t -> consumer.accept(pos2, t));
        }
        toRemove.forEach(pos -> ((FPBExtension)((Object)this)).deployer$getExtra().remove(pos));
        if (!toRemove.isEmpty()) {
            this.blockEntity.notifyUpdate();
        }
    }

    public int getTimer() {
        return ((FactoryPanelBehaviourAccessor)((Object)this)).timer();
    }

    public int getLastReportedLevelInStorage() {
        return ((FactoryPanelBehaviourAccessor)((Object)this)).lastReportedLevelInStorage();
    }

    public int getLastReportedUnloadedLinks() {
        return ((FactoryPanelBehaviourAccessor)((Object)this)).lastReportedUnloadedLinks();
    }

    public int getLastReportedPromises() {
        return ((FactoryPanelBehaviourAccessor)((Object)this)).lastReportedPromises();
    }

    public PanelType<?> getPanelType() {
        return this.type;
    }

    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return null;
    }

    public void destroy() {
        super.destroy();
        SmartBlockEntity smartBlockEntity = this.blockEntity;
        if (smartBlockEntity instanceof FactoryPanelBlockEntity) {
            FactoryPanelBlockEntity be = (FactoryPanelBlockEntity)smartBlockEntity;
            FactoryPanelBehaviour newBehaviour = new FactoryPanelBehaviour(be, this.slot);
            newBehaviour.active = false;
            this.blockEntity.attachBehaviourLate((BlockEntityBehaviour)newBehaviour);
            be.panels.put(this.slot, newBehaviour);
            be.redraw = true;
            be.lastShape = null;
            be.notifyUpdate();
        }
    }

    @ApiStatus.Internal
    public void read(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(nbt, registries, clientPacket);
        CompoundTag panelTag = nbt.getCompound(CreateLang.asId((String)this.slot.name()));
        if (panelTag.isEmpty()) {
            this.active = false;
            return;
        }
        this.active = true;
        this.easyRead(panelTag, registries, clientPacket);
    }

    @ApiStatus.Internal
    public void writeSafe(CompoundTag nbt, HolderLookup.Provider registries) {
        super.writeSafe(nbt, registries);
        CompoundTag special = nbt.contains("CustomPanels") ? nbt.getCompound("CustomPanels") : new CompoundTag();
        special.putString(CreateLang.asId((String)this.slot.name()), Objects.requireNonNull(DeployerRegistries.PANEL.getKey(this.type)).toString());
        nbt.put("CustomPanels", (Tag)special);
    }

    @ApiStatus.Internal
    public void write(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        CompoundTag special = nbt.contains("CustomPanels") ? nbt.getCompound("CustomPanels") : new CompoundTag();
        special.putString(CreateLang.asId((String)this.slot.name()), Objects.requireNonNull(DeployerRegistries.PANEL.getKey(this.type)).toString());
        nbt.put("CustomPanels", (Tag)special);
        super.write(nbt, registries, clientPacket);
        if (!this.active) {
            return;
        }
        CompoundTag panelTag = new CompoundTag();
        panelTag.putBoolean("Satisfied", this.satisfied);
        panelTag.putBoolean("PromisedSatisfied", this.promisedSatisfied);
        panelTag.putBoolean("RedstonePowered", this.redstonePowered);
        panelTag.put("Targeting", (Tag)CatnipCodecUtils.encode((Codec)CatnipCodecs.set((Codec)FactoryPanelPosition.CODEC), (Object)this.targeting).orElseThrow());
        panelTag.put("TargetedBy", (Tag)CatnipCodecUtils.encode((Codec)Codec.list((Codec)FactoryPanelConnection.CODEC), new ArrayList(this.targetedBy.values())).orElseThrow());
        panelTag.put("TargetedByLinks", (Tag)CatnipCodecUtils.encode((Codec)Codec.list((Codec)FactoryPanelConnection.CODEC), new ArrayList(this.targetedByLinks.values())).orElseThrow());
        FPBExtension extra = (FPBExtension)((Object)this);
        panelTag.put("TargetedByExtra", (Tag)CatnipCodecUtils.encode((Codec)Codec.list((Codec)FactoryPanelConnection.CODEC), new ArrayList<FactoryPanelConnection>(extra.deployer$getExtra().values())).orElseThrow());
        if (this.withFilteringBehaviour()) {
            panelTag.put("Filter", this.getFilter().saveOptional(registries));
            panelTag.putInt("FilterAmount", this.count);
            panelTag.putBoolean("UpTo", this.upTo);
        }
        this.easyWrite(panelTag, registries, clientPacket);
        nbt.put(CreateLang.asId((String)this.slot.name()), (Tag)panelTag);
    }

    @ApiStatus.Internal
    public boolean canShortInteract(ItemStack toApply) {
        return this.withFilteringBehaviour() && super.canShortInteract(toApply);
    }

    public ItemStack getFilter() {
        return this.getConnectionValue(DeployerPanelConnections.ITEM_STACK).orElse(ItemStack.EMPTY);
    }

    public void notifyRedstoneOutputs() {
        for (FactoryPanelPosition panelPos : this.targeting) {
            if (!this.getWorld().isLoaded(panelPos.pos())) {
                return;
            }
            FactoryPanelBehaviour behaviour = FactoryPanelBehaviour.at((BlockAndTintGetter)this.getWorld(), (FactoryPanelPosition)panelPos);
            if (behaviour == null) continue;
            behaviour.checkForRedstoneInput();
        }
        ((FactoryPanelBehaviourIMixin)((Object)this)).invokeNotifyRedstoneOutputs();
    }

    public boolean acceptsValueSettings() {
        return true;
    }

    @NotNull
    public Component getDisplayName() {
        return this.getItem().getDefaultInstance().getHoverName();
    }

    public ItemRequirement getRequiredItems() {
        return this.isActive() ? new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, this.getItem()) : ItemRequirement.NONE;
    }

    public static class PanelConnectionBuilder {
        private final Map<PanelConnection<?>, Supplier<?>> map = new Reference2ObjectArrayMap();

        private PanelConnectionBuilder() {
        }

        public <T> PanelConnectionBuilder put(@NotNull DeferredHolder<PanelConnection<?>, PanelConnection<T>> panelConnection, @NotNull Supplier<T> getter) {
            return this.put((PanelConnection)panelConnection.get(), getter);
        }

        public <T> PanelConnectionBuilder put(@NotNull PanelConnection<T> panelConnection, @NotNull Supplier<T> getter) {
            this.map.put(panelConnection, getter);
            return this;
        }
    }
}

