/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.deployer.lib.logistics;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.createmod.catnip.codecs.stream.CatnipStreamCodecBuilders;
import net.liukrast.deployer.lib.helper.CodecHelpers;
import net.liukrast.deployer.lib.logistics.packager.StockInventoryType;
import net.liukrast.deployer.lib.logistics.stockTicker.GenericOrderContained;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record GenericPackageOrderData<V>(int orderId, int linkIndex, boolean isFinalLink, int fragmentIndex, boolean isFinal, @Nullable GenericOrderContained<V> orderContext) {
    public GenericPackageOrderData(int orderId, int linkIndex, boolean isFinalLink, int fragmentIndex, boolean isFinal, Optional<GenericOrderContained<V>> orderContext) {
        this(orderId, linkIndex, isFinalLink, fragmentIndex, isFinal, (GenericOrderContained<V>)orderContext.orElse(null));
    }

    public static <V> Codec<GenericPackageOrderData<V>> createCodec(Supplier<StockInventoryType<?, V, ?>> supplierType) {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("order_id").forGetter(GenericPackageOrderData::orderId), (App)Codec.INT.fieldOf("link_index").forGetter(GenericPackageOrderData::linkIndex), (App)Codec.BOOL.fieldOf("is_final_link").forGetter(GenericPackageOrderData::isFinalLink), (App)Codec.INT.fieldOf("fragment_index").forGetter(GenericPackageOrderData::fragmentIndex), (App)Codec.BOOL.fieldOf("is_final").forGetter(GenericPackageOrderData::isFinal), (App)CodecHelpers.Normal.deferredCodec(() -> GenericPackageOrderData.lambda$createCodec$0((Supplier)supplierType)).optionalFieldOf("order_context").forGetter(i -> Optional.ofNullable(i.orderContext))).apply((Applicative)instance, GenericPackageOrderData::new));
    }

    public static <V> StreamCodec<RegistryFriendlyByteBuf, GenericPackageOrderData<V>> createStreamCodec(Supplier<StockInventoryType<?, V, ?>> supplierType) {
        return StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, GenericPackageOrderData::orderId, (StreamCodec)ByteBufCodecs.INT, GenericPackageOrderData::linkIndex, (StreamCodec)ByteBufCodecs.BOOL, GenericPackageOrderData::isFinalLink, (StreamCodec)ByteBufCodecs.INT, GenericPackageOrderData::fragmentIndex, (StreamCodec)ByteBufCodecs.BOOL, GenericPackageOrderData::isFinal, (StreamCodec)CatnipStreamCodecBuilders.nullable(CodecHelpers.Stream.deferredStreamCodec(() -> ((StockInventoryType)supplierType.get()).valueHandler().orderContainedStreamCodec())), GenericPackageOrderData::orderContext, GenericPackageOrderData::new);
    }

    private static /* synthetic */ Codec lambda$createCodec$0(Supplier supplierType) {
        return ((StockInventoryType)supplierType.get()).valueHandler().orderContainedCodec();
    }
}

