/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.deployer.lib.helper;

import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelConnection;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.simibubi.create.content.redstone.nixieTube.NixieTubeBlockEntity;
import com.simibubi.create.foundation.ponder.CreateSceneBuilder;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.function.Consumer;
import net.createmod.ponder.api.element.TextElementBuilder;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.liukrast.deployer.lib.mixinExtensions.FPBExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.SignBlockEntity;

public class PonderSceneHelper {
    private PonderSceneHelper() {
    }

    public static CreateSceneBuilder simpleInit(SceneBuilder builder, SceneBuildingUtil util, String id) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title(id, "");
        scene.configureBasePlate(0, 0, 7);
        scene.scaleSceneView(0.825f);
        scene.setSceneOffsetY(-2.0f);
        scene.world().showIndependentSection(util.select().fromTo(7, 0, 0, 0, 0, 7), Direction.UP);
        scene.idle(10);
        return scene;
    }

    public static void displayText(SceneBuilder builder, BlockPos pos, int time, boolean keyframe) {
        TextElementBuilder overlay = builder.overlay().showText(time).text("").placeNearTarget().pointAt(pos.getCenter().add(-0.25, 0.25, 0.0));
        if (keyframe) {
            overlay.attachKeyFrame();
        }
        builder.idle(time + 20);
    }

    public static void activateRedstone(SceneBuilder builder, BlockPos pos) {
        builder.world().toggleRedstonePower(builder.getScene().getSceneBuildingUtil().select().position(pos));
        builder.effects().indicateRedstone(pos);
    }

    public static void setSignText(SceneBuilder builder, BlockPos pos, int line, Component text) {
        builder.world().modifyBlockEntity(pos, SignBlockEntity.class, be -> be.setText(be.getText(true).setMessage(line, text), true));
    }

    public static void setNixieTubeText(SceneBuilder builder, BlockPos start, Component text, int length, Direction direction) {
        int i = 0;
        while (i < length) {
            int index = i++;
            builder.world().modifyBlockEntityNBT(builder.getScene().getSceneBuildingUtil().select().position(start.relative(direction, index)), NixieTubeBlockEntity.class, nbt -> {
                String asRaw = Component.Serializer.toJson((Component)text, (HolderLookup.Provider)builder.world().getHolderLookupProvider());
                nbt.putString("RawCustomText", asRaw);
                nbt.putString("CustomText", asRaw);
                nbt.putInt("CustomTextIndex", index);
            });
        }
    }

    public static class Gauge {
        private Gauge() {
        }

        public static void setPanelItem(SceneBuilder builder, FactoryPanelPosition gauge, ItemStack item) {
            Gauge.withGaugeDo(builder, gauge, pb -> pb.setFilter(item));
        }

        public static void setPanelPowered(SceneBuilder builder, FactoryPanelPosition gauge, boolean power) {
            Gauge.withGaugeDo(builder, gauge, pb -> {
                pb.redstonePowered = power;
            });
        }

        public static void setPanelVisible(SceneBuilder builder, FactoryPanelPosition gauge, boolean visible) {
            Gauge.withGaugeDo(builder, gauge, pb -> {
                pb.active = visible;
            });
        }

        public static void setPanelPassive(SceneBuilder builder, FactoryPanelPosition gauge) {
            Gauge.withGaugeDo(builder, gauge, pb -> {
                pb.count = 0;
            });
        }

        public static void setPanelSatisfied(SceneBuilder builder, FactoryPanelPosition gauge) {
            Gauge.withGaugeDo(builder, gauge, pb -> {
                pb.count = 1;
            });
        }

        public static void setPanelNotSatisfied(SceneBuilder builder, FactoryPanelPosition gauge) {
            Gauge.withGaugeDo(builder, gauge, pb -> {
                pb.count = 2;
            });
        }

        public static void setPanelCrafting(SceneBuilder builder, SceneBuildingUtil util, FactoryPanelPosition gauge) {
            builder.world().modifyBlockEntityNBT(util.select().position(gauge.pos()), FactoryPanelBlockEntity.class, tag -> {
                CompoundTag panelTag = tag.getCompound(CreateLang.asId((String)gauge.slot().name()));
                panelTag.putInt("LastPromised", 1);
            });
        }

        public static void flash(SceneBuilder builder, FactoryPanelPosition gauge) {
            Gauge.withGaugeDo(builder, gauge, pb -> pb.bulb.setValue(1.0));
        }

        public static void setConnectionAmount(SceneBuilder builder, FactoryPanelPosition from, FactoryPanelPosition to, int amount) {
            Gauge.withGaugeDo(builder, from, pb -> {
                ((FactoryPanelConnection)pb.targetedBy.get((Object)to)).amount = amount;
            });
        }

        public static void removePanelConnections(SceneBuilder builder, FactoryPanelPosition gauge) {
            Gauge.withGaugeDo(builder, gauge, FactoryPanelBehaviour::disconnectAll);
        }

        public static void setArrowMode(SceneBuilder builder, FactoryPanelPosition gauge, FactoryPanelPosition from, int mode) {
            Gauge.withGaugeDo(builder, gauge, pb -> {
                FactoryPanelConnection connection = (FactoryPanelConnection)pb.targetedBy.get(new FactoryPanelPosition(from.pos(), from.slot()));
                if (connection == null && (connection = (FactoryPanelConnection)pb.targetedByLinks.get(from.pos())) == null && (connection = ((FPBExtension)pb).deployer$getExtra().get(from.pos())) == null) {
                    return;
                }
                connection.arrowBendMode = mode;
            });
        }

        public static void addPanelConnection(SceneBuilder builder, FactoryPanelPosition gauge, FactoryPanelPosition from) {
            Gauge.withGaugeDo(builder, gauge, pb -> pb.addConnection(new FactoryPanelPosition(from.pos(), from.slot())));
        }

        public static void withGaugeDo(SceneBuilder builder, FactoryPanelPosition gauge, Consumer<FactoryPanelBehaviour> consumer) {
            builder.world().modifyBlockEntity(gauge.pos(), FactoryPanelBlockEntity.class, be -> consumer.accept((FactoryPanelBehaviour)be.panels.get(gauge.slot())));
        }
    }
}

