/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.deployer.lib.helper;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.liukrast.deployer.lib.DeployerConstants;
import net.liukrast.deployer.lib.helper.CodecHelpers;
import net.liukrast.deployer.lib.logistics.GenericPackageOrderData;
import net.liukrast.deployer.lib.logistics.packager.StockInventoryType;
import net.liukrast.deployer.lib.logistics.stockTicker.GenericOrderContained;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;

public class MinecraftHelpers {
    private MinecraftHelpers() {
    }

    public static CreativeModeTab.Builder createMainTab(String modId, ItemStack icon) {
        return CreativeModeTab.builder().title((Component)Component.translatable((String)("itemGroup." + modId))).icon(() -> icon);
    }

    public static <V> DataComponentType.Builder<GenericPackageOrderData<V>> createOrderData(Supplier<StockInventoryType<?, V, ?>> typeSupplier) {
        return DataComponentType.builder().persistent(GenericPackageOrderData.createCodec(typeSupplier)).networkSynchronized(GenericPackageOrderData.createStreamCodec(typeSupplier));
    }

    public static <V> DataComponentType.Builder<GenericOrderContained<V>> createContext(Supplier<StockInventoryType<?, V, ?>> typeSupplier) {
        return DataComponentType.builder().persistent(CodecHelpers.Normal.createContained(typeSupplier)).networkSynchronized(CodecHelpers.Stream.createContained(typeSupplier));
    }

    public static class ModelProvider {
        public static BlockModelBuilder createGauge(BlockModelProvider instance, Item item, Function<String, String> texture) {
            ResourceLocation id = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)item));
            return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)instance.getBuilder(id.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile(DeployerConstants.id("block/template_gauge", new Object[0])))).texture("texture", ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)texture.apply(id.getPath())))).texture("particle", ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)texture.apply(id.getPath())));
        }

        public static BlockModelBuilder createGauge(BlockModelProvider instance, Item item) {
            return ModelProvider.createGauge(instance, item, id -> "block/" + id);
        }

        public static BlockModelBuilder createPanel(BlockModelProvider instance, Item item) {
            return ModelProvider.createGauge(instance, item, id -> "block/" + id.split("_")[0] + "_panel");
        }
    }
}

